/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.core.v2_1;

import com.roguewave.chart.overlay.core.v2_1.Scaler;

public class Log10Scaler
implements Scaler {
    private static final double logOf10 = Math.log(10.0);
    int lowIncrement_;
    int pixelsPerIncrement_;

    public Log10Scaler(int lowIncrement, int pixelsPerIncrement) {
        this.lowIncrement_ = lowIncrement;
        this.pixelsPerIncrement_ = pixelsPerIncrement;
    }

    public int scale(double value) {
        return (int)((Log10Scaler.log10(value) - (double)this.lowIncrement_) * (double)this.pixelsPerIncrement_ + 0.5);
    }

    public static double log10(double x) {
        return Math.log(x) / logOf10;
    }
}

